<?php
/**
 * Plugin Name: Ajax Post Slider
 * Description: An AJAX post slider for WordPress
 * Version: 1.0
 * Author: opc
 * Author URI: https://allaboutbasic.com
 */

// Register the AJAX action
require_once( dirname( __FILE__ ) . '/functions.php' );
add_action('wp_ajax_fetch_posts', 'fetch_posts');
add_action('wp_ajax_nopriv_fetch_posts', 'fetch_posts');
function custom_excerpt($post, $limit) {
  $excerpt = explode(' ', get_the_excerpt($post), $limit);
  if (count($excerpt) >= $limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  } 
  $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
  return $excerpt;
}
function fetch_posts() {
 
 
	if(get_option('title_color')){
			$title_color = get_option('title_color');
			}
			
if(get_option('text_color')){
			$text_color = get_option('text_color');
			}
    $page = intval($_POST['page']);
    $posts_per_page = intval($_POST['posts_per_page']);
 

    $args = array(
	  'post_type' => 'post',
        'post_status' => 'publish',
        'posts_per_page' => $posts_per_page,
        'paged'          => $page  ,
		'cat'=>get_option( 'selected_category' )
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();

            $featured_image = get_the_post_thumbnail_url(get_the_ID(), 'large');
            $title = get_the_title();
            $excerpt = get_the_excerpt();
			$excerpt = custom_excerpt(get_the_ID(), 20);
			
            ?>
            <div style="display: flex;" class="slider-inner-con">
                <div  class="slider-inner-con-left">
                    <img src="<?php echo esc_url($featured_image); ?>" alt="<?php echo esc_attr($title); ?>" style="width: 100%;">
                </div>
                <div style="padding: 20px;" class="slider-inner-con-right">
                    <h2 ><a href="<?php echo the_permalink();?>" style=" color: <?php echo $title_color;?>"><?php echo esc_html($title); ?></a></h2>
                    <p style="color: <?php echo $text_color;?>"><?php echo esc_html($excerpt); ?></p>
                </div>
            </div>
            <?php
        }
    }

    wp_reset_postdata();
    wp_die();
}

// Register the shortcode
add_shortcode('ajax_post_slider', 'ajax_post_slider');

function ajax_post_slider() {
    ob_start();
    ?>
<style>
.slider-wrap {
    background-color: #E8E8E8;
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
	position: relative;
}
.slider-nav {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
}
.slider-inner-con {
    width: 60%;
    display: flex;
    flex-wrap: wrap;
    margin: 0 auto;
}

.slider-inner-con-left {
    width: 40%;
}

.slider-inner-con-right {
    width: 60%;
    padding: 20px;
}

@media (max-width: 767px) {
    .slider-wrap {
        height: auto;
        padding-top: 30px;
    }
    .slider-inner-con {
        width: 100%;
    }
    .slider-inner-con-left {
        width: 100%;
    }
    .slider-inner-con-right {
        width: 100%;
    }
}
.slider-inner-con-left img {
    /* position: absolute; */
    width: 100% !important;
    height: 100% !important;
    object-fit: cover !important;
}



 

.slider-nav-prev {
    left: 10px;
}

 
.slider-nav-next {
    right: 10px;
}
.slider-nav {
    position: absolute;
  background: white;
    transform: translateY(-50%);
    font-size: 2em;
    padding: 0.5em 1em;
   
    border: none;
    cursor: pointer;
}
 
</style>
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.14.0/css/all.css" >

<?php
if(get_option('background_color')){
			$background_color = get_option('background_color');
			}
			 
			?>
    <div class="slider-wrap" style="background-color: <?php echo $background_color;?>" >
        
		<i class="fas fa-arrow-left slider-nav-prev slider-nav"></i>

        <div class="slider-inner" id="slider">
            <!-- Posts will be fetched and displayed here -->
        </div>
         
		<i class="fas fa-arrow-right slider-nav-next slider-nav"></i>
    </div>
<script>
jQuery(document).ready(function($) {
  var current_page = 1;
  var posts_per_page = 1;
  var total_posts;


var category_id = <?php echo json_encode( get_option( 'selected_category' ) ); ?>;

console.log("Hi Om"+category_id);
  function fetch_posts(page) {
	  
 
    $.ajax({
      url: '<?php echo admin_url("admin-ajax.php"); ?>',
      type: 'post',
      data: {
        action: 'fetch_posts',
        page: page,
        posts_per_page: posts_per_page, 
	     
      },
      success: function(response) {
        $('.slider-inner').html(response);
      },
      complete: function(jqXHR) {
		  
      $.ajax({
  url: '<?php echo get_home_url();?>/wp-json/wp/v2/posts?categories='+category_id,
  method: 'GET',
  success: function(posts) {
    total_posts = posts.length;
    console.log(total_posts);
  }
});

      }
    });
  }

  // Fetch the first page of posts
  fetch_posts(current_page);

  // Handle the right arrow button click
  $('.slider-nav-next').click(function() {
    current_page++;
    if (current_page > total_posts) {
      current_page = 1;
    }
    fetch_posts(current_page);
  });

  // Handle the left arrow button click
  $('.slider-nav-prev').click(function() {
    if (current_page > 1) {
      current_page--;
    } else {
      current_page = total_posts;
    }
    fetch_posts(current_page);
  });
});
</script>
<?php
    return ob_get_clean();
}
